/*
 * Project          C++ Implementation of a Command Line programm for converting physical unit and creating corresponding Conversion Tables"
 * Author           Amar Khelil, www.khelil.de, Copyright 2014-2015
 * Documentation    http://www.khelil.de/Ref_Projekte_Intern/C/Project_C++_ConversionTable_EN.html
 *
 * MAIN
 */

// Framework C, C++
#include <iostream>
#include <string>

// Framework qt
#include <QCoreApplication>
#include <QString>
//#include <QTextStream>

// Framework CL_UnitConversionTable
#include "converter_generic.h"
#include "converter_temperature.h"
#include "cl_calculator.h"

// List of local function invoked by main
void    show_Banner(                void);
void    test_converter_generic(     void);
void    test_converter_temperature( void);
void    test_calculator(            void);

//-------------------------------------------------------------------------------------------------
int main(int argc, char *argv[])
//-------------------------------------------------------------------------------------------------
{
    QCoreApplication a(argc, argv);
    show_Banner();

//  test_converter_temperature();
    test_calculator();

//  ensure that the program pauses before it ends
    std::cin.clear();               // reset any error flags
    std::cin.ignore(32767,'\n');    // ignore any character characters in the input buffer until an enter character is identified
    std::cin.get();                 // get one more character from the user

//  return a.exec();
    return 0;
}

//-------------------------------------------------------------------------------------------------
void    show_Banner(void)
//-------------------------------------------------------------------------------------------------
{
    std::cout << std::endl << "----------------------------------------------------------------------------------------------------";
    std::cout << std::endl << "(main/show_Banner) Program Conversion Table";
    std::cout << std::endl << "----------------------------------------------------------------------------------------------------";
    std::cout << std::endl << "Autor           : Amar Khelil, www.khelil.de, copyright 2014-2016, all rights reserved";
    std::cout << std::endl;
    std::cout << std::endl << "Motivation      : ";
    std::cout << std::endl << "Console implementation of a conversion unit calculator before developing an appropriate GUI application";
    std::cout << std::endl;
    std::cout << std::endl << "More information:";
    std::cout << std::endl << "see http://www.khelil.de/Ref_Projekte_Intern/C/Project_C++_ConversionTable_EN.html";
    std::cout << std::endl << "----------------------------------------------------------------------------------------------------";
    std::cout << std::endl;
    return;
}

//-------------------------------------------------------------------------------------------------
void    test_converter_temperature(void)
//-------------------------------------------------------------------------------------------------
{

    converter_temperature*  CT = new converter_temperature();

    std::cout   << "Name of Converter is \t\t" << CT->getName_Converter().toLocal8Bit().data() << std::endl;
    std::cout   << "Number of units   is \t\t" << CT->get_nUnit() << std::endl;
    std::cout   << std::endl;

    for (int ii=0; ii < CT->get_nUnit(); ii++)
    {
        std::cout   << "Unit " << ii << " is "              << CT->getName_UID(ii).toLocal8Bit().data() << std::endl;
    }
    std::cout   << std::endl << "Reference-Unit  is "       << CT->getName_UID_Ref().toLocal8Bit().data() << std::endl;

    CT->setValue_C(10);
    std::cout   << std::endl << "Unit Celsius has been set to  \t\t" << CT->getVal_UID(unit_celsius) << std::endl;

    for (int ii=0; ii < CT->get_nUnit(); ii++)
    {
        std::cout   << "Current value of Unit " << CT->getName_UID(ii).toLocal8Bit().data() << " is \t" << CT->getVal_UID(ii) << std::endl;
    }

    int    ref_unit;
    double val_ref_unit;

    do
    {
        std::cout   << std::endl << "Select id of reference Unit (-1 to abort process) : ";
        std::cin    >> ref_unit;

        std::cout   << "Enter current measurement value of reference Unit : ";
        std::cin    >> val_ref_unit;

        CT->set_UID_Ref(ref_unit);
        CT->setVal_UID_Ref(val_ref_unit);

        for (int ii=0; ii < CT->get_nUnit(); ii++)
        {
            std::cout << std::endl << "Current value of Unit " << CT->getName_UID(ii).toLocal8Bit().data() << " is \t" << CT->getVal_UID(ii);
        }

        std::cout << std::endl;

    } while (ref_unit != -1);

    delete CT;

    return;
}   // void    test_converter_temperature(void)

//-------------------------------------------------------------------------------------------------
void    test_calculator(void)
//-------------------------------------------------------------------------------------------------
{
    cl_calculator* TheCalc = cl_calculator::getTheCalculator();

    bool            more_It    = false;
    std::string     answer;

    do {
        std::cin.ignore(100,'\n');
        std::cout << std::endl << "->Do you want to calculate another conversion table? (y or yes) : ";
        std::getline (std::cin,answer);
        std::cout << std::endl << "answer=[" << answer << "]";

        if (toupper (answer[0]) == 'Y')
        {
            more_It = true;
            TheCalc->do_iteration();
        }
        else
        {
            more_It = false;
            std::cout << std::endl << "->Treatment aborted: "<< TheCalc->get_n_iteration() << " iterations have been performed. bye.";
        }
    } while (more_It);

    delete    TheCalc;
    return;
}

