/*
 * Project          C++ Implementation of a Command Line Program converting physical units and creating corresponding conversion tables
 * Author           Amar Khelil, www.khelil.de, Copyright 2014-2015
 * Documentation    http://www.khelil.de/Ref_Projekte_Intern/C/Project_C++_ConversionTable_EN.html
 *
 * DEFINITION       of global constants - and a few variables too
 */

// QT FRAMEWORK
#include <QString>

#include "global_UnitConversionTable.h"


static int  output_level(OUTPUT_QUIET);                     // variables have implicitly external linkage

//-------------------------------------------------------------------
namespace glb_UCT
//-------------------------------------------------------------------
{
    extern  const   double      ARBITRARY_VALUE(0.0);           // constants have implicitly static linkage
    extern  const   QString     UNKNOWN_NAME("Unknown_Name");


    // used in order to format the output
    extern  const   int         SETW_INDEX(5);
    extern  const   int         SETW_INT(5);
    extern  const   int         SETW_NAME(30);
    extern  const   int         SETW_METHOD_NAME(55);
    extern  const   int         SETW_VAL(15);

    //I could have written a define clause to be treated by the preprocessor instead.




    //-------------------------------------------------------------------
    int     get_output_level(void)
    //-------------------------------------------------------------------
    {
        return output_level;
    } // end of function

    //-------------------------------------------------------------------
    void    set_output_level(int lvl)
    //-------------------------------------------------------------------
    {
        if ( (lvl>= OUTPUT_QUIET) && (lvl< n_output_levels))
        {
            output_level = lvl;
        }
        else
        {
            output_level = OUTPUT_QUIET;
        }
    } // end of function

} // end of namespace

