/*
 * Project          C++ Implementation "Unit Conversion Table"
 * Author           Amar Khelil, www.khelil.de, Copyright 2014-2016
 * Documentation    http://www.khelil.de/Ref_Projekte_Intern/C/Project_C++_ConversionTable_EN.html
 *
 * Converter for units associated with time
 */
#ifndef CONVERTER_TIME_H
#define CONVERTER_TIME_H

// Framework C, C++

// Framework qt
#include <QString>

// Framework CL_UnitConversionTable
#include "converter_generic.h"

// CONSTANTS SPECIFIC TO TIME


// Names of units associated to time
enum    enum_unit_time {
            unit_day,           // By default the reference unit
            unit_year,
            unit_month,
            unit_hour,
            unit_second,
            nUNIT_TIME
        };

/*
 * Class converter_time
 *
 * A timer has a current state, the duration value,
 * represented according to the units listed in  enum_unit_time
 *
 * Unit values are converted as the user wishes:
 *
 * day to year:     D = Y/365.25
 * day to month:    D = M/30.0       (as some German lows assume)
 * day to hour:     D = 24.0*H
 * day to second:   D = 24.0*3600*S
 * year to day      Y = 365.25*D
 * month to day:    M = 30.0*D
 * hour to day:     H = 1/24.0*D
 * second to day    S = 1/24.0/3600.0/D
 * More functions are not necessary to cover up every case.
*/

// All converter classes derives from abstract class converter_generic
//-------------------------------------------------------------------------------------------------
class converter_time    : public converter_generic
//-------------------------------------------------------------------------------------------------
{

public:
//  constructors, destructors
            converter_time(     void);
            converter_time(     QString CName);
            ~converter_time(    );

private:
    void    init(               void);

public:
//  virtual functions must be defined now
//  Part of the initialization process
    void    generateArray_names_unit(      void);
    void    generateArray_vals_unit(        void);
//  Part of the calculation process
    void    setVal_UID(                     double val, int uid);

// Real world implementation (time)
public:
//  SET functions
    void    setValue_Y(     double year);
    void    setValue_M(     double month);
    void    setValue_D(     double day);
    void    setValue_H(     double hour);
    void    setValue_S(     double second);

// CONVERSION functions (internal invocation within SET functions)
private:
    double convert_D_2_Y(   double day);    // day      to year
    double convert_D_2_M(   double day);    // day      to month
    double convert_D_2_H(   double day);    // day      to hour
    double convert_D_2_S(   double day);    // day      to second

    double convert_Y_2_D(   double year);   // year     to day
    double convert_M_2_D(   double month);  // month    to day
    double convert_H_2_D(   double hour);   // hour     to day
    double convert_S_2_D(   double second); // second   to day

};

#endif // CONVERTER_TIME_H
