/*
 * Project          C++ Implementation "Unit Conversion Table"
 * Author           Amar Khelil, www.khelil.de, Copyright 2014-2016
 * Documentation    http://www.khelil.de/Ref_Projekte_Intern/C/Project_C++_ConversionTable_EN.html
 *
 * File             converter_temperature.h
 * Title            Converter for units associated with temperature
 * Last modified    12 Feb 2016
 */

#ifndef CONVERTER_TEMPERATURE_H
#define CONVERTER_TEMPERATURE_H

// Framework C, C++

// Framework qt
#include <QString>

// Framework CL_UnitConversionTable
#include "converter_generic.h"

// CONSTANTS SPECIFIC TO TEMPERATURE

// Legal temperature range of thermometers in use [-MAX_CELSIUS; +MAX_CELSIUS]
const   double          MAX_CELSIUS      = 10000.0;

// Names of units associated to temperature
enum    enum_unit_temperature {
            unit_celsius,           // By default, the reference unit
            unit_fahrenheit,
            unit_kelvin,
            nUNIT_TEMPERATURE
        };

    /* Class converter_temperature
     *
     * A thermometer has a current state, its temperature value,
     * represented according to the units listed in enum_unit_temperature.
     *
     * Unit values are converted as the user wishes.
     * Following conversion formulas will be used:
     * Celsius into Fahrenheit: F = (C * 9/5) + 32
     * Celsius into Kelvin    : K = C + 273.15
     * Fahrenheit into Celsius: C = (F -32) * 5/9
     * Kelvin into Celsius    : C = K - 273.15
     * More functions are not necessary to cover up any possible case.
     *
     * */

// All converter classes derives from abstract class converter_generic
//-------------------------------------------------------------------------------------------------
class converter_temperature : public converter_generic
//-------------------------------------------------------------------------------------------------
{

public:
//###  CONSTRUCTORS, DESTRUCTORS
    converter_temperature(      void);
    converter_temperature(      QString CName);
    ~converter_temperature(     );

private:
//  OBJECT INITIALIZATION
    void    init(                           void);

public:
//  VIRTUAL functions must be defined now
    void    generateArray_names_unit(       void);
    void    generateArray_vals_unit(        void);
//  Part of the calculation process
    void    setVal_UID(                     double val, int uid);

// REAL WORLD implementation (temperature)
public:
//  SET functions
    void    setValue_C(         double Celsius);
    void    setValue_F(         double Fahrenheit);
    void    setValue_K(         double Kelvin);

// CONVERSION functions (internal invocation within SET functions)
private:
    double  convert_C_2_F(      double Celsius);
    double  convert_C_2_K(      double Celsius);
    double  convert_F_2_C(      double Fahrenheit);
    double  convert_K_2_C(      double Kelvin);


public:  // (just for checking)
    //  Output the measured value
        double  getValue_C(         void);
        double  getValue_F(         void);
        double  getValue_K(         void);
};

#endif
