/*
 * Project          C++ Implementation "Unit Conversion Table"
 * Author           Amar Khelil, www.khelil.de, Copyright 2014-2015
 * Documentation    http://www.khelil.de/Ref_Projekte_Intern/C/Project_C++_ConversionTable_EN.html
 *
 * File             converter_temperature.cpp
 * Title            Converter associated with temprature
 * Last modified    02 Feb 2016
 *
 */

#include <iostream>
#include <iomanip>

#include "global_UnitConversionTable.h"
#include "converter_temperature.h"


//=====================================
//### CONSTRUCTORS DESTRUCTORS
//=====================================
//-------------------------------------------------------------------------------------------------
converter_temperature::converter_temperature(void): converter_generic()
//-------------------------------------------------------------------------------------------------
{
    if (glb_UCT::get_output_level() == OUTPUT_DEBUG)
    {
        std::cout << std::endl<< ">Constructor converter_temperature::converter_temperature() [Begin]";
    }

    init(); // object initialization

    if (glb_UCT::get_output_level() == OUTPUT_DEBUG)
    {
        std::cout << std::endl<< ">Constructor converter_temperature::converter_temperature() [End]";
    }
}

//-------------------------------------------------------------------------------------------------
converter_temperature::converter_temperature(QString CName): converter_generic(CName)
//-------------------------------------------------------------------------------------------------
{
    if (glb_UCT::get_output_level() == OUTPUT_DEBUG)
    {
        std::cout   << std::endl
                    << ">Constructor converter_temperature::converter_temperature("
                    << CName.toLocal8Bit().data()
                    << ") [Begin]";
    }

    init();

    if (glb_UCT::get_output_level() == OUTPUT_DEBUG)
    {
        std::cout << std::endl
                  << ">Constructor converter_temperature::converter_temperature("
                  << CName.toLocal8Bit().data()
                  << ") [End]";

    }
}

//-------------------------------------------------------------------------------------------------
converter_temperature::~converter_temperature()
//-------------------------------------------------------------------------------------------------
{
    if (glb_UCT::get_output_level() == OUTPUT_DEBUG)
    {
        std::cout << std::endl
                  << ">Destructor converter_temperature::~converter_temperature"
                  << "(name="
                  << name_converter.toLocal8Bit().data()
                  << ", id="
                  << id_Conv
                  << ") [Begin] [End]";
    }
}

//=====================================
//### INITIALIZE OBJECT
//=====================================

//-------------------------------------------------------------------------------------------------
void  converter_temperature::init(void)
//-------------------------------------------------------------------------------------------------
{
    if (glb_UCT::get_output_level() == OUTPUT_DEBUG)
    {
        std::cout << std::endl << ">converter_temperature::init() [Begin]";
    }

//  Conversion variables: generic <-> specific
    n_units                     = nUNIT_TEMPERATURE;

    generateArray_names_unit();        //  defines names_unit[]
    generateArray_vals_unit();          //  defines vals_unit[]
//  id_ref_unit = 0;                    // By default the reference unit is the first one (May be changed by the user)

    if (glb_UCT::get_output_level() == OUTPUT_DEBUG)
    {
        std::cout << std::endl<< ">converter_temperature::init() [End]";
    }

    return;
}

//-------------------------------------------------------------------------------------------------
void  converter_temperature::generateArray_names_unit(void)
//-------------------------------------------------------------------------------------------------
{
    if (glb_UCT::get_output_level() == OUTPUT_DEBUG)
    {
            std::cout << std::endl
                      << ">converter_temperature::generateArray_names_unit() [Begin] (creates and populates array for unit names)";
    }

    names_unit                    = new QString[nUNIT_TEMPERATURE];
    names_unit[unit_celsius]      = "celsius    (C)";
    names_unit[unit_fahrenheit]   = "fahrenheit (F)";
    names_unit[unit_kelvin]       = "kelvin     (K)";

    if (glb_UCT::get_output_level() == OUTPUT_DEBUG)
    {
            std::cout << std::endl
                      << ">converter_temperature::generateArray_names_unit() [End]";
    }
    return;
}

//-------------------------------------------------------------------------------------------------
void  converter_temperature::generateArray_vals_unit(void)
//-------------------------------------------------------------------------------------------------
{
    if (glb_UCT::get_output_level() == OUTPUT_DEBUG)
    {
        std::cout << std::endl
                  << ">converter_temperature::generateArray_vals_unit() [Begin] (creates and populates array of unit values)";
    }

    vals_unit                   = new double[nUNIT_TEMPERATURE];
    setValue_C(                 glb_UCT::ARBITRARY_VALUE);
    return;
}

//-------------------------------------------------------------------------------------------------
void  converter_temperature::setVal_UID(double val, int uid)
//-------------------------------------------------------------------------------------------------
{
    if (glb_UCT::get_output_level() == OUTPUT_DEBUG)
    {
        std::cout << std::endl << ">converter_temperature::setVal_UID(" << "val="<< val<<", uid="<< uid << ") [Begin] )";
    }

    switch (uid)
    {

        case unit_celsius:
            setValue_C(val);
        break;

        case unit_fahrenheit:
            setValue_F(val);
        break;

        case unit_kelvin:
            setValue_K(val);
        break;

        default:
            std::cout << std::endl << "->ERROR uid="<< uid << " is not a legal unit ID!";
    }
    return;
}


// -2- SET functions
// The consistency between temperature values acoording to all registered units is always maintained
//-------------------------------------------------------------------------------------------------
void converter_temperature::setValue_C(double Celsius)
//-------------------------------------------------------------------------------------------------
{
     vals_unit[unit_celsius]    = Celsius;
     vals_unit[unit_kelvin]     = convert_C_2_K(Celsius);
     vals_unit[unit_fahrenheit] = convert_C_2_F(Celsius);
    return;
}

//-------------------------------------------------------------------------------------------------
void converter_temperature::setValue_F(double Fahrenheit)
//-------------------------------------------------------------------------------------------------
{
    vals_unit[unit_fahrenheit] = Fahrenheit;
    vals_unit[unit_celsius]    = convert_F_2_C(Fahrenheit);
    vals_unit[unit_kelvin]     = convert_C_2_K(vals_unit[unit_celsius]);

    return;
}

//-------------------------------------------------------------------------------------------------
void converter_temperature::setValue_K(double Kelvin)
//-------------------------------------------------------------------------------------------------
{
    vals_unit[unit_kelvin]     = Kelvin;
    vals_unit[unit_celsius]    = convert_K_2_C(Kelvin);
    vals_unit[unit_fahrenheit] = convert_C_2_F(vals_unit[unit_celsius]);
    return;
}

// -3- Specific functions for GETTING a temparature value
//-------------------------------------------------------------------------------------------------
double converter_temperature::getValue_C(void)
//-------------------------------------------------------------------------------------------------
{
    return vals_unit[unit_celsius];
}

//-------------------------------------------------------------------------------------------------
double converter_temperature::getValue_F(void)
//-------------------------------------------------------------------------------------------------
{
    return vals_unit[unit_fahrenheit];
}

//-------------------------------------------------------------------------------------------------
double converter_temperature::getValue_K(void)
//-------------------------------------------------------------------------------------------------
{
    return vals_unit[unit_kelvin];
}


//### CONVERSION METHODS
//-------------------------------------------------------------------------------------------------
double converter_temperature::convert_C_2_F(double Celsius)
//-------------------------------------------------------------------------------------------------
{
    double Fahrenheit = (Celsius * 9.0/5.0) + 32.0;
    return Fahrenheit;
}

//-------------------------------------------------------------------------------------------------
double converter_temperature::convert_C_2_K(double Celsius)
//-------------------------------------------------------------------------------------------------
{
    double Kelvin = Celsius + 273.15;
    return (Kelvin);
}

//-------------------------------------------------------------------------------------------------
double converter_temperature::convert_F_2_C(double Fahrenheit)
//-------------------------------------------------------------------------------------------------
{
    double Celsius = (Fahrenheit - 32) * 5.0/9.0;
    return (Celsius);
}

//-------------------------------------------------------------------------------------------------
double converter_temperature::convert_K_2_C(double Kelvin)
//-------------------------------------------------------------------------------------------------
{
    double Celsius = Kelvin - 273.15;
    return (Celsius);
}


